/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.FileSystemBuildPath;
import com.aptana.editor.php.internal.builder.ILibraryListener;
import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import com.aptana.editor.php.internal.builder.ProjectBuildPath;
import com.aptana.editor.php.internal.builder.UserLibrary;
import com.aptana.editor.php.internal.builder.WorkspaceFolderBuildpath;
import com.aptana.editor.php.internal.builder.preferences.DependenciesManager;
import com.aptana.editor.php.internal.builder.preferences.IProjectDependencyListener;
import com.aptana.editor.php.internal.builder.preferences.ProjectDependencies;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathsListener;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public final class BuildPathManager {
    private static Object mutex = new Object();
    private static BuildPathManager instance = null;
    private Map<Object, IBuildPath> buildPaths = new HashMap<Object, IBuildPath>();
    private Set<IBuildPathsListener> listeners = new HashSet<IBuildPathsListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildPathManager getInstance() {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                instance = new BuildPathManager();
            }
            return instance;
        }
    }

    public synchronized List<IBuildPath> getBuildPaths() {
        ArrayList<IBuildPath> result = new ArrayList<IBuildPath>();
        result.addAll(this.buildPaths.values());
        return result;
    }

    public synchronized IBuildPath getBuildPathByResource(Object resource) {
        return this.buildPaths.get(resource);
    }

    public synchronized IModule getModuleByResource(Object resource) {
        if (resource == null) {
            return null;
        }
        for (IBuildPath path : this.buildPaths.values()) {
            IModule module;
            if (path == null || (module = path.getModule(resource)) == null) continue;
            return module;
        }
        return null;
    }

    public synchronized IDirectory getDirectoryByResource(Object resource) {
        for (IBuildPath path : this.buildPaths.values()) {
            IDirectory directory = path.getDirectory(resource);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    public synchronized void addBuildPathChangeListener(IBuildPathsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeBuildPathChangeListener(IBuildPathsListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized IBuildPath addBuildPath(Object resource) {
        IBuildPath path = this.createBuildPathByResource(resource);
        this.internalAddBuldPath(resource, path);
        return path;
    }

    private void internalAddBuldPath(Object resource, IBuildPath path) {
        this.buildPaths.put(resource, path);
        ArrayList<IBuildPath> added = new ArrayList<IBuildPath>(1);
        ArrayList<IBuildPath> removed = new ArrayList<IBuildPath>(0);
        added.add(path);
        this.notifyChanged(added, removed);
    }

    public synchronized void removeBuildPath(Object resource) {
        IBuildPath path = this.getBuildPathByResource(resource);
        if (path == null) {
            return;
        }
        this.buildPaths.remove(resource);
        ArrayList<IBuildPath> added = new ArrayList<IBuildPath>(0);
        ArrayList<IBuildPath> removed = new ArrayList<IBuildPath>(1);
        removed.add(path);
        this.notifyChanged(added, removed);
    }

    private BuildPathManager() {
        long l0 = System.currentTimeMillis();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.indexExternalLibraries();
        this.indexLocalProjects(workspace);
        this.bindListeners(workspace);
        IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("Indexer init: " + (System.currentTimeMillis() - l0) + "ms)"), null, (String)"com.aptana.editor.php/debug");
    }

    public void indexExternalLibraries() {
        IPHPLibrary[] all;
        IPHPLibrary[] iPHPLibraryArray = all = LibraryManager.getInstance().getAllLibraries();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            for (String s : l.getDirectories()) {
                File path = new File(s);
                if (path == null) continue;
                FileSystemBuildPath fileSystemBuildPath = new FileSystemBuildPath(path);
                this.internalAddBuldPath(path, fileSystemBuildPath);
            }
            ++n2;
        }
        LibraryManager.getInstance().addLibraryListener(new ILibraryListener(){

            @Override
            public void librariesChanged(Set<IPHPLibrary> turnedOn, Set<IPHPLibrary> turnedOf) {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    root.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) {
                            if (!resource.isAccessible()) {
                                return false;
                            }
                            if (resource instanceof IProject) {
                                if (BuildPathManager.this.buildPaths.containsKey(resource)) {
                                    IProject project = (IProject)resource;
                                    ProjectDependencies dependencies = DependenciesManager.getDependencies(project);
                                    BuildPathManager.this.handleDependenciesChange(project, dependencies);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error handling a libraries change", (Throwable)e);
                }
            }

            @Override
            public void userLibrariesChanged(UserLibrary[] newLibraries) {
                File file;
                List<String> directories;
                IPHPLibrary l;
                IPHPLibrary[] current;
                Set<IPHPLibrary> emptySet = Collections.emptySet();
                HashSet<File> files = new HashSet<File>();
                for (Object o : BuildPathManager.this.buildPaths.keySet()) {
                    if (!(o instanceof File)) continue;
                    files.add((File)o);
                }
                HashSet currrentFiles = new HashSet(files);
                IPHPLibrary[] iPHPLibraryArray = current = LibraryManager.getInstance().getAllLibraries();
                int n = current.length;
                int n2 = 0;
                while (n2 < n) {
                    l = iPHPLibraryArray[n2];
                    directories = l.getDirectories();
                    for (String s : directories) {
                        file = new File(s);
                        files.remove(file);
                    }
                    ++n2;
                }
                for (File f : files) {
                    IBuildPath path = BuildPathManager.this.getBuildPathByResource(f);
                    BuildPathManager.this.removeBuildPath(f);
                    path.close();
                    currrentFiles.remove(f);
                }
                iPHPLibraryArray = newLibraries;
                n = newLibraries.length;
                int n3 = 0;
                while (n3 < n) {
                    l = iPHPLibraryArray[n3];
                    if (LibraryManager.getInstance().isTurnedOn(l)) {
                        directories = ((UserLibrary)l).getDirectories();
                        for (String s : directories) {
                            file = new File(s);
                            if (BuildPathManager.this.buildPaths.containsKey(file)) continue;
                            FileSystemBuildPath fileSystemBuildPath = new FileSystemBuildPath(file);
                            BuildPathManager.this.internalAddBuldPath(file, fileSystemBuildPath);
                        }
                    }
                    ++n3;
                }
                this.librariesChanged(emptySet, emptySet);
            }
        });
    }

    private void bindListeners(IWorkspace workspace) {
        IResourceChangeListener workspaceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                HashSet<IProject> added = new HashSet<IProject>();
                HashSet<IProject> removed = new HashSet<IProject>();
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    IResourceDelta[] affectedChildren;
                    IResourceDelta[] iResourceDeltaArray = affectedChildren = event.getDelta().getAffectedChildren();
                    int n = affectedChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                        IResource resource = resourceDelta.getResource();
                        if (resource instanceof IProject) {
                            IProject project = resource.getProject();
                            try {
                                switch (resourceDelta.getKind()) {
                                    case 1: {
                                        if (project.isAccessible()) {
                                            this.addProject(project, added);
                                        }
                                        break;
                                    }
                                    case 2: {
                                        this.removeProject(project, removed);
                                        break;
                                    }
                                    case 4: {
                                        if (project.isAccessible()) {
                                            this.addProject(project, added);
                                            break;
                                        }
                                        this.removeProject(project, removed);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error handling a resource-change event", (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                } else if (event.getResource() instanceof IProject && event.getType() == 2) {
                    removed.add((IProject)event.getResource());
                }
                if (!added.isEmpty() || !removed.isEmpty()) {
                    BuildPathManager.this.handleChanged(added, removed);
                }
            }

            private void addProject(IProject project, Set<IProject> toAdd) throws CoreException {
                if (project.hasNature("com.aptana.editor.php.phpNature") && !BuildPathManager.this.buildPaths.containsKey(project)) {
                    toAdd.add(project);
                }
            }

            private void removeProject(IProject project, Set<IProject> toRemove) {
                if (BuildPathManager.this.buildPaths.containsKey(project)) {
                    toRemove.add(project);
                }
            }
        };
        workspace.addResourceChangeListener(workspaceListener);
        DependenciesManager.addListener(new IProjectDependencyListener(){

            @Override
            public void dependenciesChanged(IProject project, ProjectDependencies dependencies) {
                if (!project.isAccessible()) {
                    return;
                }
                BuildPathManager.this.handleDependenciesChange(project, dependencies);
            }
        });
    }

    public void handleChanged(Set<IProject> added, Set<IProject> removed) {
        IBuildPath path;
        ArrayList<IBuildPath> addedPaths = new ArrayList<IBuildPath>();
        ArrayList<IBuildPath> removedPaths = new ArrayList<IBuildPath>();
        if (added.isEmpty() && removed.isEmpty()) {
            return;
        }
        ArrayList<IProject> toRemove = new ArrayList<IProject>();
        for (IProject addedProject : added) {
            path = this.createBuildPathByResource(addedProject);
            if (path == null) continue;
            this.buildPaths.put(addedProject, path);
            addedPaths.add(path);
        }
        for (IProject removedProject : removed) {
            path = this.getBuildPathByResource(removedProject);
            if (path == null) continue;
            removedPaths.add(path);
            toRemove.add(removedProject);
        }
        for (IProject toRemoveProject : toRemove) {
            path = this.buildPaths.get(toRemoveProject);
            this.buildPaths.remove(toRemoveProject);
            this.removeDepencies(path);
        }
        for (IBuildPath path2 : removedPaths) {
            path2.close();
        }
        this.notifyChanged(addedPaths, removedPaths);
        if (!added.isEmpty()) {
            this.updateProjectsDependencies(ResourcesPlugin.getWorkspace().getRoot());
        }
        PHPGlobalIndexer.getInstance().indexLocalModules();
    }

    private void notifyChanged(List<IBuildPath> added, List<IBuildPath> removed) {
        for (IBuildPathsListener listener : this.listeners) {
            try {
                listener.changed(added, removed);
            }
            catch (Throwable th) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Unable notifying build path change listener", (Throwable)th);
            }
        }
    }

    private void indexLocalProjects(IWorkspace workspace) {
        IWorkspaceRoot root = workspace.getRoot();
        try {
            root.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (!resource.isAccessible()) {
                        return false;
                    }
                    if (resource instanceof IProject) {
                        IBuildPath path;
                        if (!BuildPathManager.this.buildPaths.containsKey(resource) && (path = BuildPathManager.this.createBuildPathByResource(resource)) != null) {
                            BuildPathManager.this.buildPaths.put(resource, path);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing local projects", (Throwable)e);
        }
        this.updateProjectsDependencies(root);
    }

    private void updateProjectsDependencies(IWorkspaceRoot root) {
        try {
            root.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (!resource.isAccessible()) {
                        return false;
                    }
                    if (resource instanceof IProject) {
                        if (BuildPathManager.this.buildPaths.containsKey(resource)) {
                            IProject project = (IProject)resource;
                            ProjectDependencies dependencies = DependenciesManager.getDependencies(project);
                            BuildPathManager.this.handleDependenciesChange(project, dependencies);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error updating the project dependencies", (Throwable)e);
        }
    }

    private IBuildPath createBuildPathByResource(Object resource) {
        if (resource instanceof IResource) {
            if (!((IResource)resource).isAccessible()) {
                return null;
            }
            if (resource instanceof IProject) {
                IProject project = (IProject)resource;
                try {
                    if (((IProject)resource).hasNature("com.aptana.editor.php.phpNature")) {
                        return new ProjectBuildPath(project);
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error creating a build-path", (Throwable)e);
                }
            }
        } else if (resource instanceof File && ((File)resource).exists() && ((File)resource).isDirectory()) {
            return new FileSystemBuildPath((File)resource);
        }
        return null;
    }

    private void handleDependenciesChange(IProject project, ProjectDependencies dependencies) {
        IBuildPath dependencyBuildPath;
        IBuildPath path = this.buildPaths.get(project);
        if (path == null) {
            return;
        }
        path.clearDependencies();
        for (IResource projectDependency : dependencies.getWorkspaceResources()) {
            if (projectDependency instanceof IProject) {
                dependencyBuildPath = this.buildPaths.get(projectDependency);
                if (dependencyBuildPath == null) continue;
                path.addDependency(dependencyBuildPath);
                continue;
            }
            if (!(projectDependency instanceof IFolder)) continue;
            dependencyBuildPath = new WorkspaceFolderBuildpath((IFolder)projectDependency);
            path.addDependency(dependencyBuildPath);
        }
        for (File directoryDependency : dependencies.getDirectories()) {
            dependencyBuildPath = this.addBuildPath(directoryDependency);
            path.addDependency(dependencyBuildPath);
        }
        IPHPLibrary[] allLibraries = LibraryManager.getInstance().getAllLibraries();
        HashSet<IPHPLibrary> usedLibraries = new HashSet<IPHPLibrary>(Arrays.asList(allLibraries));
        if (dependencies.isUsesCustomLibs()) {
            List<String> notUsedLibrariesIds = dependencies.getNotUsedLibrariesIds();
            for (String s : notUsedLibrariesIds) {
                IPHPLibrary library = LibraryManager.getInstance().getLibrary(s);
                if (library == null) continue;
                usedLibraries.remove(library);
            }
        } else {
            IPHPLibrary[] iPHPLibraryArray = allLibraries;
            int n = allLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                IPHPLibrary l = iPHPLibraryArray[n2];
                if (!l.isTurnedOn()) {
                    usedLibraries.remove(l);
                }
                ++n2;
            }
        }
        for (IPHPLibrary l : usedLibraries) {
            for (String s : l.getDirectories()) {
                File fl = new File(s);
                IBuildPath dependency = this.buildPaths.get(fl);
                if (dependency == null) continue;
                path.addDependency(dependency);
            }
        }
    }

    private void removeDepencies(IBuildPath path) {
        for (IBuildPath currentPath : this.buildPaths.values()) {
            currentPath.removeDependency(path);
        }
    }
}

